#!/usr/bin/env ruby
#
# Update iChat/Adium status from Twitter
#
# Setup:
#   1. Save to ~/Library/Scripts
#   2. Edit 'Username' below to match your username
#   3. Open Terminal
#   4. Make the script executable: chmod +x ~/Library/Scripts/sync-status-with-twitter.rb
#   5. Open your crontab: crontab -e
#   6. Add a line to crontab to run the script regularly:
#           Press 'o' to insert a new line
#           Paste the following line (no space at start of line):
#              */30 * * * * ~/Library/Scripts/sync-status-with-twitter.rb
#           The '30' here means run every 30 minutes. Change it if you want. Some alternatives are:
#                  */10 * * * *.... - Every 10 minutes
#                  0 * * * *....    - Hourly, on the hour
#                  0 */2 * * *....  - Every second hour, on the hour
#           Press escape to stop editing
#           Hold down shift and press ZZ (Z key twice) to save and quit
#   7. You're done
#
# Michael Tyson <mike@tyson.id.au> 
# http://michael.tyson.id.au


# Set username here
Username = 'MyTwitterUsername'


require 'net/http'
require 'rexml/document'

# Download timeline XML and extract latest entry
url = "http://twitter.com/statuses/user_timeline/" + Username + ".atom"
xml_data = Net::HTTP.get_response(URI.parse(url)).body
doc    = REXML::Document.new(xml_data)
message = doc.root.elements["entry/content[not(contains(text(), '@'))]"].to_s.gsub(/^[^:]+:\s*/, '')

exit if ! message

# Apply to status
script = 'set message to "' + message.gsub(/"/, '\\"') + "\"\n" +
         'tell application "System Events"' + "\n" +
         'if exists process "iChat" then tell application "iChat" to if status ≠ away then set the status message to message' + "\n" +
         'if exists process "Adium" then tell application "Adium" to if status type of global status ≠ away then set status message of every account to message' + "\n" +
         'end tell' + "\n"


IO.popen("osascript", "w") { |f| f.puts(script) }
